using System;
using System.Diagnostics.Contracts;

namespace CaseStudy
{

public class TLists
{

	// Is `[fromIndex..toIndex)' a valid interval within `[0..a.length)'?
	[Pure]
	[ContractVerification(false)]
	public static bool within(object[] a, int fromIndex, int toIndex)
	{
		Contract.Requires (a != null);
		Contract.Ensures (!Contract.Result<bool>() || 0 <= fromIndex && fromIndex <= toIndex && toIndex <= a.Length);
		Contract.Ensures ( Contract.Result<bool>() || 0 >  fromIndex || fromIndex >  toIndex || toIndex >  a.Length);
		if (a == null)
			throw new Exception();
			return (0 <= fromIndex && fromIndex <= toIndex && toIndex <= a.Length);
	}

	// Does `a' contain an element `key' within [fromIndex..toIndex)?
	[Pure]
	[ContractVerification(false)]
	public static bool In(object[] a, int fromIndex, int toIndex, object key)
	{
		Contract.Requires (a != null);
		Contract.Requires (within(a, fromIndex, toIndex));
		Contract.Ensures (!Contract.Result<bool>() ||  Contract.Exists(fromIndex, toIndex, i => a[i] == key));
		Contract.Ensures ( Contract.Result<bool>() || !Contract.Exists(fromIndex, toIndex, i => a[i] == key));
		if (a == null)
			throw new Exception();
		if (!within(a, fromIndex, toIndex))
			throw new Exception();

		if (fromIndex >= toIndex) {
			return false;
		} else {
			object first = a[fromIndex];
			return (first == key) || In(a, fromIndex + 1, toIndex, key);
		}
	}

	// Does a[fromIndex..toIndex) == val?
	[Pure]
	[ContractVerification(false)]
	public static bool eq(object[] a, int fromIndex, int toIndex, object val)
	{
		Contract.Requires (a != null);
		// Contract.Requires (within(a, fromIndex, toIndex)); inlined for better analysis
        Contract.Requires(0 <= fromIndex && fromIndex <= toIndex && toIndex <= a.Length);
		Contract.Ensures (!Contract.Result<bool>() ||  Contract.ForAll(fromIndex, toIndex, i => a[i] == val));
		Contract.Ensures ( Contract.Result<bool>() || !Contract.ForAll(fromIndex, toIndex, i => a[i] == val));
		if (a == null)
			throw new Exception();
		if (!within(a, fromIndex, toIndex))
			throw new Exception();
			if (fromIndex >= toIndex) {
			return true;
		} else {
			object first = a[fromIndex];
			return (first == val) && eq(a, fromIndex + 1, toIndex, val);
		}
	}

	// Does a[fromIndex..toIndex) != val?
	[Pure]
	[ContractVerification(false)]
	public static bool neq(object[] a, int fromIndex, int toIndex, object val)
	{
		Contract.Requires (a != null);
		Contract.Requires (within(a, fromIndex, toIndex));
		Contract.Ensures (!Contract.Result<bool>() ||  Contract.ForAll(fromIndex, toIndex, i => a[i] != val));
		Contract.Ensures ( Contract.Result<bool>() || !Contract.ForAll(fromIndex, toIndex, i => a[i] != val));
		if (a == null)
			throw new Exception();
		if (!within(a, fromIndex, toIndex))
			throw new Exception();
			if (fromIndex >= toIndex) {
			return true;
		} else {
			object first = a[fromIndex];
			return (first != val) && neq(a, fromIndex + 1, toIndex, val);
		}
	}

	// Does the triple (els, head, tail) define a valid deq?
	[Pure]
	[ContractVerification(false)]
	public static bool deqValid(object[] els, int head, int tail)
	{
		Contract.Ensures (!Contract.Result<bool>() ||  (els != null && 0 <= head && head < els.Length && 0 <= tail && tail < els.Length && els[tail] == null));
		Contract.Ensures ( Contract.Result<bool>() || !(els != null && 0 <= head && head < els.Length && 0 <= tail && tail < els.Length && els[tail] == null));
		return ( els != null && 0 <= head && head < els.Length && 0 <= tail && tail < els.Length && els[tail] == null );
	}

	// Is `ic' a valid index within the deq defined by (els, head, tail)?
	[Pure]
	[ContractVerification(false)]
	public static bool deqWithin(object[] els, int head, int tail, int ic)
	{
	Contract.Requires (deqValid(els, head, tail));
		Contract.Ensures (!Contract.Result<bool>() ||  (((head >  tail || (head <= ic && ic <= tail)) && (head <= tail || (head <= ic && ic < els.Length || 0 <= ic && ic <= tail)))));
		Contract.Ensures ( Contract.Result<bool>() || !(((head >  tail || (head <= ic && ic <= tail)) && (head <= tail || (head <= ic && ic < els.Length || 0 <= ic && ic <= tail)))));
		if (!deqValid(els, head, tail))
			throw new Exception();
			if (head <= tail) {
			return head <= ic && ic <= tail;
		} else {
			return head <= ic && ic < els.Length || 0 <= ic && ic <= tail;
		}
	}

	// Does the deq defined by (els, head, tail) has no element with value `val' within `[head..ic)'?
	// The interval `[head..ic)' wraps over if tail < head.
	[Pure]
	[ContractVerification(false)]
	public static bool deqHasNot(object[] els, int head, int tail, int ic, object val) {
		Contract.Requires(deqValid(els, head, tail));
		Contract.Requires(deqWithin(els, head, tail, ic));
		Contract.Ensures (!Contract.Result<bool>() ||   ((head > tail || neq(els, head, ic, val)) && (head <= tail || ((head <= ic && ic < els.Length && neq(els, head, ic, val)) || (0 <= ic && ic <= tail && (neq(els, head, els.Length, val) || neq(els, 0, ic, val)))))));
		Contract.Ensures ( Contract.Result<bool>() || ! ((head > tail || neq(els, head, ic, val)) && (head <= tail || ((head <= ic && ic < els.Length && neq(els, head, ic, val)) || (0 <= ic && ic <= tail && (neq(els, head, els.Length, val) || neq(els, 0, ic, val)))))));
		if (!deqValid(els, head, tail))
			throw new Exception();
		if (!deqWithin(els, head, tail, ic))
			throw new Exception();
		if (head <= tail) {
			return neq(els, head, ic, val);
		} else {
			if (head <= ic && ic < els.Length)
				return neq(els, head, ic, val);
			else
				return neq(els, head, els.Length, val) && neq(els, 0, ic, val);
		}
	}

	// Does the deq defined by (els, head, tail) has an element with value `val' within `[head..ic)'?
	// The interval `[head..ic)' wraps over if tail < head.
	[Pure]
	[ContractVerification(false)]
	public static bool deqHas(object[] els, int head, int tail, int ic, object val) {
		Contract.Ensures (!Contract.Result<bool>() ||   ((head > tail || neq(els, head, ic, val)) && (head <= tail || ((head <= ic && ic < els.Length && !neq(els, head, ic, val)) || (0 <= ic && ic <= tail && (!neq(els, head, els.Length, val) || !neq(els, 0, ic, val)))))));
		Contract.Ensures ( Contract.Result<bool>() || ! ((head > tail || neq(els, head, ic, val)) && (head <= tail || ((head <= ic && ic < els.Length && !neq(els, head, ic, val)) || (0 <= ic && ic <= tail && (!neq(els, head, els.Length, val) || !neq(els, 0, ic, val)))))));
		return !deqHasNot (els, head, tail, ic, val);
	}

	// Is `[fromIndex..toIndex)' a valid interval within `al'?
	[Pure]
	[ContractVerification(false)]
	public static bool within(ArrayList al, int fromIndex, int toIndex)
	{
		Contract.Requires (al != null);
		Contract.Ensures (!Contract.Result<bool>() ||  0 <= fromIndex && fromIndex <= toIndex && toIndex <= al.size);
		Contract.Ensures ( Contract.Result<bool>() ||  0 >  fromIndex || fromIndex >  toIndex || toIndex >  al.size);
		if (al == null)
			throw new Exception();
			return 0 <= fromIndex && fromIndex <= toIndex && toIndex <= al.Size();
	}

	// Does al[fromIndex..toIndex) != val?
	[Pure]
	[ContractVerification(false)]
	public static bool neq(ArrayList al, int fromIndex, int toIndex, object val)
	{
		Contract.Requires (al != null);
		Contract.Requires (within(al, fromIndex, toIndex));
		Contract.Ensures (!Contract.Result<bool>() ||  Contract.ForAll(fromIndex, toIndex, i => al.elementData[i] != val));
		Contract.Ensures ( Contract.Result<bool>() || !Contract.ForAll(fromIndex, toIndex, i => al.elementData[i] != val));
		if (al == null)
			throw new Exception();
		if (!within(al, fromIndex, toIndex))
			throw new Exception();
		return neq(al.getElementData(), fromIndex, toIndex, val);
	}

	// Is the list `al' sorted in ascending order over [`fromIndex'..`toIndex')?
	// We sort based on the hash code.
	[Pure]
	[ContractVerification(false)]
	public static bool sorted(ArrayList al, int fromIndex, int toIndex)
	{
		Contract.Requires (al != null);
		Contract.Requires (within(al, fromIndex, toIndex));
		Contract.Requires (neq(al, fromIndex, toIndex, null));
		Contract.Ensures (!Contract.Result<bool>() ||  Contract.ForAll(fromIndex, toIndex - 1, i => al.elementData[i].GetHashCode () <= al.elementData[i + 1].GetHashCode()));
		Contract.Ensures ( Contract.Result<bool>() || !Contract.ForAll(fromIndex, toIndex - 1, i => al.elementData[i].GetHashCode () <= al.elementData[i + 1].GetHashCode()));
		Contract.Ensures (!Contract.Result<bool>() ||  TArrays.sorted (al.getElementData(), fromIndex, toIndex));
		Contract.Ensures ( Contract.Result<bool>() || !TArrays.sorted (al.getElementData(), fromIndex, toIndex)); 
		if (al == null)
			throw new Exception();
		if (!within(al, fromIndex, toIndex))
			throw new Exception();
		if (!neq(al, fromIndex, toIndex, null))
			throw new Exception();

		return TArrays.sorted(al.getElementData(), fromIndex, toIndex);
	}
}
}