using System;
using System.Diagnostics.Contracts;

namespace CaseStudy
{

public class TArrays
{

	// Skip empty()

	// Is x a valid position in `a'?
	[Pure]
	[ContractVerification(false)]
	public static bool in_bound(int[] a, int x)
	{
		Contract.Requires(a != null);
		Contract.Ensures (!Contract.Result<bool>() ||  (0 <= x && x < a.Length));
		Contract.Ensures ( Contract.Result<bool>() || !(0 <= x && x < a.Length));
		if (a == null)
			throw new Exception();

		return (0 <= x && x < a.Length);
	}

	// Is `[fromIndex..toIndex)' a valid interval within `[0..a.length)'?
	[Pure]
	[ContractVerification(false)]
	public static bool within(int[] a, int fromIndex, int toIndex)
	{
		Contract.Requires (a != null);
		Contract.Ensures (!Contract.Result<bool>() ||  (0 <= fromIndex && fromIndex <= toIndex && toIndex <= a.Length));
		Contract.Ensures ( Contract.Result<bool>() || !(0 <= fromIndex && fromIndex <= toIndex && toIndex <= a.Length));
		if (a == null)
			throw new Exception();

		return (0 <= fromIndex && fromIndex <= toIndex && toIndex <= a.Length);
	}

	// Is `[fromIndex..toIndex)' a valid interval within `[0..a.length)'?
	[Pure]
	[ContractVerification(false)]
	public static bool within(object[] a, int fromIndex, int toIndex)
	{
		Contract.Requires (a != null);
		Contract.Ensures (!Contract.Result<bool>() ||  (0 <= fromIndex && fromIndex <= toIndex && toIndex <= a.Length));
		Contract.Ensures ( Contract.Result<bool>() || !(0 <= fromIndex && fromIndex <= toIndex && toIndex <= a.Length));
		if (a == null)
			throw new Exception();

		return (0 <= fromIndex && fromIndex <= toIndex && toIndex <= a.Length);
	}

	// Is `a' sorted within `[fromIndex..toIndex)'?
	// Sorting is based on the hash code.
	[Pure]
	[ContractVerification(false)]
	public static bool sorted(int[] a, int fromIndex, int toIndex)
	{
		Contract.Requires (a != null);
		Contract.Requires(within(a, fromIndex, toIndex));
		Contract.Ensures (!Contract.Result<bool>() ||  Contract.ForAll(fromIndex, toIndex - 1, i => a[i] <= a[i+1]));
		Contract.Ensures ( Contract.Result<bool>() || !Contract.ForAll(fromIndex, toIndex - 1, i => a[i] <= a[i+1]));
		if (a == null)
			throw new Exception();
		if (!within(a, fromIndex, toIndex))
			throw new Exception();

		if (toIndex - fromIndex <= 1) {
			return true;
		} else {
			int first = a[fromIndex], second = a[fromIndex + 1];
			return first <= second && sorted(a, fromIndex + 1, toIndex);
		}
	}

	// Is `a' sorted within `[fromIndex..toIndex)'?
	// Sorting is based on the hash code.
	[Pure]
	[ContractVerification(false)]
	public static bool sorted(object[] a, int fromIndex, int toIndex)
	{
		Contract.Requires (a != null);
		Contract.Requires(within(a, fromIndex, toIndex));
		Contract.Requires(nonnull (a, fromIndex, toIndex));
		Contract.Ensures (!Contract.Result<bool>() ||  Contract.ForAll(fromIndex, toIndex - 1, i => a[i].GetHashCode () <= a[i+1].GetHashCode()));
		Contract.Ensures ( Contract.Result<bool>() || !Contract.ForAll(fromIndex, toIndex - 1, i => a[i].GetHashCode () <= a[i+1].GetHashCode()));
		if (a == null)
			throw new Exception();
		if (!within(a, fromIndex, toIndex))
			throw new Exception();
		if (!nonnull(a, fromIndex, toIndex))
			throw new Exception();

		if (toIndex - fromIndex <= 1) {
			return true;
		} else {
			object first = a[fromIndex], second = a[fromIndex + 1];
			return first.GetHashCode() <= second.GetHashCode() && sorted(a, fromIndex + 1, toIndex);
		}
	}

	// Does `a' contain an element `key' within [fromIndex..toIndex)?
	[Pure]
	[ContractVerification(false)]
	public static bool In(int[] a, int fromIndex, int toIndex, int key)
	{
		Contract.Requires (a != null);
		Contract.Requires(within(a, fromIndex, toIndex));
		Contract.Ensures(!Contract.Result<bool>() ||  Contract.Exists(fromIndex, toIndex, i => a[i] == key));
		Contract.Ensures( Contract.Result<bool>() || !Contract.Exists(fromIndex, toIndex, i => a[i] == key));
		if (a == null)
			throw new Exception();
		if (!within(a, fromIndex, toIndex))
			throw new Exception();

		if (fromIndex >= toIndex) {
			return false;
		} else {
			int first = a[fromIndex];
			return (first == key) || In(a, fromIndex + 1, toIndex, key);
		}
	}

	// Does a[fromIndex..toIndex) < key?
	[Pure]
	[ContractVerification(false)]
	public static bool less(int[] a, int fromIndex, int toIndex, int key)
	{
		Contract.Requires(a != null);
		Contract.Requires(within(a, fromIndex, toIndex));
		Contract.Ensures(!Contract.Result<bool>() ||  Contract.ForAll(fromIndex, toIndex, i => a[i] < key));
		Contract.Ensures( Contract.Result<bool>() || !Contract.ForAll(fromIndex, toIndex, i => a[i] < key));
		if (a == null)
			throw new Exception();
		if (!within(a, fromIndex, toIndex))
			throw new Exception();

		if (fromIndex >= toIndex) {
			return true;
		} else {
			int first = a[fromIndex];
			return (first < key) && less(a, fromIndex + 1, toIndex, key);
		}
	}

	// Does a[fromIndex..toIndex) > key?
	[Pure]
	[ContractVerification(false)]
	public static bool grt(int[] a, int fromIndex, int toIndex, int key)
	{
		Contract.Requires(a != null);
		Contract.Requires(within(a, fromIndex, toIndex));
		Contract.Ensures(!Contract.Result<bool>() ||  Contract.ForAll(fromIndex, toIndex, i => a[i] > key));
		Contract.Ensures( Contract.Result<bool>() || !Contract.ForAll(fromIndex, toIndex, i => a[i] > key));
		if (a == null)
			throw new Exception();
		if (!within(a, fromIndex, toIndex))
			throw new Exception();

		if (fromIndex >= toIndex) {
			return true;
		} else {
			int first = a[fromIndex];
			return (first > key) && grt(a, fromIndex + 1, toIndex, key);
		}
	}

	// Does a[aFrom..aTo) == b[bFrom..bTo)?
	[Pure]
	[ContractVerification(false)]
	public static bool eq(int[] a, int aFrom, int aTo, int[] b, int bFrom, int bTo)
	{
		Contract.Requires (a != null && b != null);
		Contract.Requires (within(a, aFrom, aTo) && within(b, bFrom, bTo));
		Contract.Ensures(!Contract.Result<bool>() ||  aTo - aFrom == bTo - bFrom && Contract.ForAll(aFrom, aTo, i => a[i] == b[bFrom + (i - aFrom)]));
		Contract.Ensures( Contract.Result<bool>() ||!(aTo - aFrom == bTo - bFrom && Contract.ForAll(aFrom, aTo, i => a[i] == b[bFrom + (i - aFrom)])));
		if (a == null || b == null)
			throw new Exception();
		if (!within(a, aFrom, aTo) || !within(b, bFrom, bTo))
			throw new Exception();

		if (aTo - aFrom != bTo - bFrom) {
			return false;
		} else { if (aFrom >= aTo) {
				return true;
			} else {
				return (a[aFrom] == b[bFrom]) && eq(a, aFrom + 1, aTo, b, bFrom + 1, bTo);
			}
		}
	}

	// Does a[fromIndex..toIndex) == key?
	[Pure]
	[ContractVerification(false)]
	public static bool eq(int[] a, int fromIndex, int toIndex, int key)
	{
		Contract.Requires (a != null);
		Contract.Requires(within(a, fromIndex, toIndex));
		Contract.Ensures(!Contract.Result<bool>() ||  Contract.ForAll(fromIndex, toIndex, i => a[i] == key));
		Contract.Ensures( Contract.Result<bool>() || !Contract.ForAll(fromIndex, toIndex, i => a[i] == key));
		if (a == null)
			throw new Exception();
		if (!within(a, fromIndex, toIndex))
			throw new Exception();

		if (fromIndex >= toIndex) {
			return true;
		} else {
			int first = a[fromIndex];
			return (first == key) && eq(a, fromIndex + 1, toIndex, key);
		}
	}
	
	// Does a[fromIndex..toIndex) == key?
	[Pure]
	[ContractVerification(false)]
	public static bool eq(object[] a, int fromIndex, int toIndex, object key)
	{
		Contract.Requires (a != null);
		Contract.Requires(within(a, fromIndex, toIndex));
		Contract.Requires(nonnull (a, fromIndex, toIndex));
		Contract.Requires(key != null);
		Contract.Ensures(!Contract.Result<bool>() ||  Contract.ForAll(fromIndex, toIndex, i => a[i] == key));
		Contract.Ensures( Contract.Result<bool>() || !Contract.ForAll(fromIndex, toIndex, i => a[i] == key));
		if (a == null)
			throw new Exception();
		if (!within(a, fromIndex, toIndex))
			throw new Exception();
		if (!nonnull(a, fromIndex, toIndex))
			throw new Exception();
		if (key == null)
			throw new Exception();

		if (fromIndex >= toIndex) {
			return true;
		} else {
			object first = a[fromIndex];
			return (first == key) && eq(a, fromIndex + 1, toIndex, key);
		}
	}

	// Does a[fromIndex..toIndex) == null?
	[Pure]
	[ContractVerification(false)]
	public static bool eqnull(object[] a, int fromIndex, int toIndex)
	{
		Contract.Requires(a != null);
		Contract.Requires(within(a, fromIndex, toIndex));
		Contract.Ensures(!Contract.Result<bool>() ||  Contract.ForAll(fromIndex, toIndex, i => a[i] == null));
		Contract.Ensures( Contract.Result<bool>() || !Contract.ForAll(fromIndex, toIndex, i => a[i] == null));
		if (a == null)
			throw new Exception();
		if (!within(a, fromIndex, toIndex))
			throw new Exception();

		if (fromIndex >= toIndex) {
			return true;
		} else {
			object first = a[fromIndex];
			return (first == null) && eqnull(a, fromIndex + 1, toIndex);
		}
	}

	// Does a[fromIndex..toIndex) != key?
	[Pure]
	[ContractVerification(false)]
	public static bool neq(object[] a, int fromIndex, int toIndex, object key)
	{
		Contract.Requires(a != null);
		Contract.Requires(within(a, fromIndex, toIndex));
		Contract.Requires(nonnull (a, fromIndex, toIndex));
		Contract.Requires(key != null);
		Contract.Ensures(!Contract.Result<bool>() ||  Contract.ForAll(fromIndex, toIndex, i => a[i] != key));
		Contract.Ensures( Contract.Result<bool>() || !Contract.ForAll(fromIndex, toIndex, i => a[i] != key));
		if (a == null)
			throw new Exception();
		if (!within(a, fromIndex, toIndex))
			throw new Exception();
		if (!nonnull(a, fromIndex, toIndex))
			throw new Exception();
		if (key == null)
			throw new Exception();

		if (fromIndex >= toIndex) {
			return true;
		} else {
			object first = a[fromIndex];
			return (first != key) && neq(a, fromIndex + 1, toIndex, key);
		}
	}


	// Does a[fromIndex..toIndex) != null?
	[Pure]
	[ContractVerification(false)]
	public static bool nonnull(object[] a, int fromIndex, int toIndex)
	{
		Contract.Requires (a != null);
		Contract.Requires(within(a, fromIndex, toIndex));
		Contract.Ensures (!Contract.Result<bool>() ||  Contract.ForAll(fromIndex, toIndex, i => a[i] != null));
		Contract.Ensures ( Contract.Result<bool>() || !Contract.ForAll(fromIndex, toIndex, i => a[i] != null));
		if (a == null)
			throw new Exception();
		if (!within(a, fromIndex, toIndex))
			throw new Exception();

		if (fromIndex >= toIndex) {
			return true;
		} else {
			object first = a[fromIndex];
			return (first != null) && nonnull(a, fromIndex + 1, toIndex);
		}
	}
}
}
