using System;
using System.Diagnostics.Contracts;

namespace CaseStudy
{

public class SystemUtil
{

    [ContractVerification(false)]
	public static void arraycopyInteger(object[] src, int srcPos, object[] dest, int destPos, int length) {
		Contract.Requires(src != null && dest != null);
		Contract.Requires(length >= 0);
		Contract.Requires(0 <= srcPos && srcPos + length <= src.Length);
		Contract.Requires(0 <= destPos && destPos + length <= dest.Length);
		// Skip assignable annotation.
		Contract.Ensures(Contract.ForAll(0, destPos, i => dest[i] == Contract.OldValue(dest[i])));
		Contract.Ensures(Contract.ForAll(0, length, i => dest[destPos + i] == Contract.OldValue(src[srcPos + i])));
		Contract.Ensures(Contract.ForAll(destPos + length, dest.Length, i => dest[i] == Contract.OldValue(dest[i])));
		Contract.Ensures(src == dest || Contract.ForAll(0, src.Length, i => src[i] == Contract.OldValue(src[i])));
		// Skipped the description of the exceptional behaviour.
		if (src == null)
			throw new NullReferenceException();
		if (dest == null)
			throw new NullReferenceException();
		if (length < 0)
			throw new IndexOutOfRangeException();
		if (srcPos < 0 || srcPos + length > src.Length)
			throw new IndexOutOfRangeException();
		if (destPos < 0 || destPos + length > dest.Length)
			throw new IndexOutOfRangeException();

		if (src == dest) {
			// Use temporary array
			object[] temp_array = new object[length];
			for (int i = 0; i < length; i++) {
				temp_array[i] = src[srcPos + i];
			}
			for (int i = 0; i < length; i++) {
				dest[destPos + i] = temp_array[i];
			}
		} else {
			for (int i = 0; i < length; i++) {
				dest[destPos + i] = src[srcPos + i];
			}
		}
	}

}
}

