using System;
using System.Diagnostics.Contracts;

namespace CaseStudy
{

public class Collections
{

    [ContractVerification(false)]
	public static void sort(ArrayList l) {
		Contract.Requires(l != null);
		Contract.Requires (TLists.neq(l, 0, l.Size(), null));
        Contract.Ensures (l.Size() == Contract.OldValue (l.Size()));
	    Contract.Ensures (TLists.neq(l, 0, l.Size(), null));
		Contract.Ensures (TLists.sorted(l, 0, l.Size()));

		object[] a = l.toArray();
		Arrays.sortInteger(a);
		Contract.Assume (a.Length == l.Size());
		Contract.Assume(TArrays.sorted(a, 0, a.Length));
        Contract.Assume(Contract.ForAll(0, a.Length, i => a[i] != null));
		l.clear();
		for (int ic = 0; ic < a.Length; ic++) {
			object elem = a[ic];
			l.add(elem);
		}
	}

    [ContractVerification(false)]
    public static void reverse(ArrayList list)
    {
        Contract.Requires(list != null);
        // Skip assignable annotation
        Contract.Ensures(Contract.ForAll(0, list.Size(), i => list.elementData[i] == Contract.OldValue(list.elementData[list.Size() - 1 - i])));

        int size = list.Size();
        int mid = size / 2;
        for (int ic = 0; ic < mid; ic++)
        {
            swap(list, ic, size - 1 - ic);
        }
    }

    [ContractVerification(false)]
    public static void swap(ArrayList list, int i, int j)
    {
        Contract.Requires(list != null);
        Contract.Requires(0 <= i && i < list.Size());
        Contract.Requires(0 <= j && j < list.Size());
        // Skip assignable annotation
        Contract.Ensures(list.elementData[i] == Contract.OldValue(list.elementData[j]));
        Contract.Ensures(list.elementData[j] == Contract.OldValue(list.elementData[i]));
        Contract.Ensures(Contract.ForAll(0, list.Size(), k => (k == i) || (k == j) || (list.elementData[k] == Contract.OldValue(list.elementData[k]))));

        object val_i = list.getIndex(i);
        object val_j = list.setIndex(j, val_i);
        list.setIndex(i, val_j);
    }

    [ContractVerification(false)]
	public static void replaceAll(ArrayList list, object oldVal, object newVal) {
		Contract.Requires (list != null);
		// Skip assignable annotation
		Contract.Ensures (oldVal != newVal || Contract.ForAll(0, list.Size(), j => list.elementData[j] == Contract.OldValue(list.elementData[j])));
		Contract.Ensures (oldVal == newVal || TLists.neq(list, 0, list.Size(), oldVal)); // inlining does not help

		if (oldVal == newVal)
			return;

		int size = list.Size();
		for (int ic = 0; ic < size; ic++) {
			object val = list.getIndex(ic);
			if (val == oldVal) {
				list.setIndex(ic, newVal);
			}
		}
	}
}
}