using System;
using System.Diagnostics.Contracts;

namespace CaseStudy
{

public class ArrayDeque
{

	public object[] elements;

	private int head;

	private int tail;

    private static int MIN_INITIAL_CAPACITY = 8;

	[ContractInvariantMethod]
    [ContractVerification(true)]
	private void ObjectInvariant() {
		Contract.Invariant(elements != null);
		Contract.Invariant(0 <= head && head < elements.Length);
		Contract.Invariant(0 <= tail && tail < elements.Length);
		Contract.Invariant(elements[tail] == null);
		// Skip owner annotation.

        Contract.Invariant(MIN_INITIAL_CAPACITY == 8);

		//Contract.Invariant(head >= tail || TLists.neq(elements, head, tail, null)); inlined for better analysis
        Contract.Invariant(head >= tail || Contract.ForAll(head, tail, i => elements[i] != null));
        //Contract.Invariant(head >= tail || TLists.eq(elements, 0, head, null)); inlined for better analysis
        Contract.Invariant(head >= tail || Contract.ForAll(0, head, i => elements[i] == null));
        //Contract.Invariant(head >= tail || TLists.eq(elements, tail, elements.Length, null)); inlined for better analysis
        Contract.Invariant(head >= tail || Contract.ForAll(tail, elements.Length, i => elements[i] == null));

        //Contract.Invariant(tail >= head || TLists.neq(elements, 0, tail, null)); inlined for better analysis
        Contract.Invariant(head >= tail || Contract.ForAll(0, tail, i => elements[i] != null));
        //Contract.Invariant(tail >= head || TLists.neq(elements, head, elements.Length, null)); inlined for better analysis
        Contract.Invariant(head >= tail || Contract.ForAll(head, elements.Length, i => elements[i] != null));
        //Contract.Invariant(tail >= head || TLists.eq(elements, tail, head, null)); inlined for better analysis
        Contract.Invariant(head >= tail || Contract.ForAll(tail, head, i => elements[i] == null));

		Contract.Invariant(head != tail || TLists.eq(elements, 0, elements.Length, null));
	}

    [ContractVerification(true)]
	public ArrayDeque() {
        MIN_INITIAL_CAPACITY = 8;
		elements = new object[16];
	}

	[Pure]
    [ContractVerification(false)]
	public bool contains(object value) {
		Contract.Ensures ( Contract.Result<bool>() || value == null || !TLists.deqHas(elements, head, tail, tail, value));
		Contract.Ensures (!Contract.Result<bool>() ||(value != null &&  TLists.deqHas(elements, head, tail, tail, value)));

		if (value == null)
			return false;

		int ic = head;
		object x = elements[ic];

		while (x != null) {
			if (value == x) {
				break;
			}
			if (ic == elements.Length) {
				ic = 0;
			} else {
				ic++;
			}
			x = elements[ic];
		}
		if (x != null) {
			return true;
		} else {
			return false;
		}
	}

    [ContractVerification(false)]
	public bool removeFirstOccurrence(object value) {
        // Skip assignable annotation.
		Contract.Ensures ( Contract.Result<bool>() || (value == null || !TLists.deqHas(elements, head, tail, tail, value)) && head == Contract.OldValue(head) && tail == Contract.OldValue(tail) && Contract.ForAll(0, elements.Length, i => elements[i] == Contract.OldValue(elements[i])));
		Contract.Ensures (!Contract.Result<bool>() ||  value != null && Contract.OldValue(TLists.deqHas(elements, head, tail, tail, value)));
		if (value == null)
			return false;

		int ic = head;
		object x = elements[ic];

		while (x != null) {
			if (value == x) {
				break;
			}
			if (ic == elements.Length) {
				ic = 0;
			} else {
				ic++;
			}
			x = elements[ic];
		}
		if (x != null) {
			delete(ic);
			return true;
		} else {
			return false;
		}
	}

	[Pure]
    [ContractVerification(false)]
	private void checkInvariants() {
		bool cond1 = elements[tail] == null;
		if (!cond1)
			throw new Exception();

		bool cond2 = (head == tail ? elements[head] == null
			: (elements[head] != null && elements[(tail - 1)
				& (elements.Length - 1)] != null));
		if (!cond2)
			throw new Exception();

		bool cond3 = (elements[(head - 1) & (elements.Length - 1)] == null);

		if (!cond3)
			throw new Exception();

	}

    [ContractVerification(false)]
	private bool delete(int index) {
		Contract.Requires (0 <= index && index < this.elements.Length);
		// Contract.Requires (TLists.deqWithin(this.elements, head, tail, index)); inlined for better analysis
        Contract.Requires((head > tail || (head <= index && index <= tail)) && (head <= tail || (head <= index && index < this.elements.Length || 0 <= index && index <= tail)));
        // Skip assignable annotation
		checkInvariants();
		object[] elements = this.elements;
		int mask = elements.Length - 1;
		int h = head;
		int t = tail;
		int front = (index - h) & mask;
		int back = (t - index) & mask;

		if (front >= ((t - h) & mask))
			throw new Exception(); // concurrent modification

		if (front < back) {
			if (h <= index) {
				SystemUtil.arraycopyInteger(elements, h, elements, h + 1, front);
			} else {
				SystemUtil.arraycopyInteger(elements, 0, elements, 1, index);
				elements[0] = elements[mask];
				SystemUtil.arraycopyInteger(elements, h, elements, h + 1, mask - h);
			}
			elements[h] = null;
			head = (h + 1) & mask;
			return false;
		} else {
			if (index < t) {
				SystemUtil.arraycopyInteger(elements, index + 1, elements, index, back);
				tail = t - 1;
			} else {
				SystemUtil.arraycopyInteger(elements, index + 1, elements, index, mask - index);
				elements[mask] = elements[0];
				SystemUtil.arraycopyInteger(elements, 1, elements, 0, t);
				tail = (t - 1) & mask;
			}
			return true;
		}
	}

    [ContractVerification(false)]
	public bool removeLastOccurrence(object value) {
		Contract.Ensures ( Contract.Result<bool>() || (value == null || !TLists.deqHas(elements, head, tail, tail, value)) && head == Contract.OldValue(head) && tail == Contract.OldValue(tail) && Contract.ForAll(0, elements.Length, i => elements[i] == Contract.OldValue(elements[i])));
		Contract.Ensures (!Contract.Result<bool>() ||  value != null && Contract.OldValue(TLists.deqHas(elements, head, tail, tail, value)));
		Contract.Ensures (head >= tail || TLists.neq(elements, head, tail, null));
		if (value == null)
			return false;

		int indexToRemove = -1;

			if (head < tail) {

			int ic = tail - 1;
			for (; ic >= head; ic--) {

				if (value == elements[ic]) {
					break;
				}
			}
			if (ic >= head) {
				indexToRemove = ic;
			}

		} else {
			int ic = tail - 1;
			for (; ic >= 0; ic--) {
				if (value == elements[ic])
					break;
			}
			if (ic >= 0) {
				indexToRemove = ic;
			} else {

				ic = elements.Length - 1;
				for (; ic >= head; ic--) {
					if (value == elements[ic])
						break;
				}
				if (ic >= head) {
					indexToRemove = ic;
				}
			}
		}

		if (indexToRemove != -1) {
			// Contract.Assert(Contract.OldValue(TLists.deqHas(elements, head, tail, tail, value))); cannot be asserted
			delete(indexToRemove);
			return true;
		} else
			return false;
	}
}
}